import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 9))

# Define grid dimensions
rows, cols = 6, 4
grid_size = 1

# Define colors for each piece and clear cells
colors = {
    'rightl0': 'blue',
    'rightl1': 'green',
    'square0': 'red',
    'square1': 'yellow',
    'clear': 'white'
}

# Define piece positions
pieces = {
    'rightl0': [(3, 0), (3, 1), (2, 0)],
    'rightl1': [(1, 0), (1, 1), (0, 0)],
    'square0': [(1, 2)],
    'square1': [(2, 2)]
}

# Draw the grid and pieces
for row in range(rows):
    for col in range(cols):
        # Determine if the cell is occupied
        occupied = False
        piece_name = ''
        for name, positions in pieces.items():
            if (row, col) in positions:
                occupied = True
                piece_name = name
                break
        
        # Set color and status text based on occupancy
        color = colors[piece_name] if occupied else colors['clear']
        status = 'occupied' if occupied else 'free'
        
        # Draw each grid cell
        rect = patches.Rectangle((col * grid_size, (rows - 1 - row) * grid_size), grid_size, grid_size, 
                                 linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)

        # Add text labels
        text_color = 'black' if color in ['white', 'yellow'] else 'white'
        ax.text(col * grid_size + 0.5 * grid_size, (rows - 1 - row) * grid_size + 0.6 * grid_size, 
                piece_name if occupied else '', ha='center', va='center', color=text_color, fontsize=8, fontweight='bold')
        ax.text(col * grid_size + 0.5 * grid_size, (rows - 1 - row) * grid_size + 0.3 * grid_size, 
                f"f{row}-{col}f\n{status}", ha='center', va='center', color=text_color, fontsize=6)

# Bold outer edges of pieces
for name, positions in pieces.items():
    for pos in positions:
        row, col = pos
        rect = patches.Rectangle((col * grid_size, (rows - 1 - row) * grid_size), grid_size, grid_size, 
                                 linewidth=3, edgecolor='black', facecolor='none')
        ax.add_patch(rect)

# Set axis limits and aspect ratio
ax.set_xlim(0, cols * grid_size)
ax.set_ylim(0, rows * grid_size)
ax.set_aspect('equal')

# Remove axis
ax.axis('off')

# Add legend
legend_elements = [
    patches.Patch(facecolor='blue', edgecolor='black', label='rightl0: occupied'),
    patches.Patch(facecolor='green', edgecolor='black', label='rightl1: occupied'),
    patches.Patch(facecolor='red', edgecolor='black', label='square0: occupied'),
    patches.Patch(facecolor='yellow', edgecolor='black', label='square1: occupied'),
    patches.Patch(facecolor='white', edgecolor='black', label='free: clear')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tetris/one_shot/ini_diagram_code/attempts/attempt_45.png', bbox_inches='tight')
plt.show()